"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface
import json
import base64
import pyqrcode

interface = meshtastic.serial_interface.SerialInterface()

node = interface.getNode('^local')
channels = node.channels

from gi.repository import Gtk, Gio, Adw, GLib

print("URL:")
print("Primary Only:")
primary_only_url = node.getURL(includeAll=False)
print(primary_only_url)
primary_url_qr = pyqrcode.create(primary_only_url)
#print(primary_url_qr.terminal(quiet_zone=1))
print("All Channels:")
all_url = node.getURL(includeAll=True)
print(all_url)
all_url_qr = pyqrcode.create(all_url)
#print(all_url_qr.terminal(quiet_zone=1))

qr_location = GLib.get_tmp_dir() + "/qr_primary.svg"
url_qr = pyqrcode.create(primary_only_url)
url_qr.svg(qr_location, scale=8)

#primary_url_qr.svg('uca-url.svg', scale=8)
#primary_url_qr.eps('uca-url.eps', scale=2)

GLib.get_tmp_dir()

print(GLib.get_tmp_dir() + "/foo.svg")


# Index: What channel it is on (0-7)
# Role: Primary (1) or secondary (2)
# PSK: AES key
# Name: Name

interface.close()
